// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit

class OverlayView: UIView {
    private var overlayBackgroundColor: UIColor
    
    init(frame: CGRect, overlayColor: UIColor) {
        overlayBackgroundColor = overlayColor
        super.init(frame: frame)
        backgroundColor = .clear
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func draw(_ rect: CGRect) {
        guard let context = UIGraphicsGetCurrentContext() else { return }

        // Fill entire view with semi-transparent color
        overlayBackgroundColor.setFill()
        context.fill(rect)

        // Calculate dimensions
        let parentWidth = frame.size.width
        let parentHeight = frame.size.height

        var maxParentSize = max(parentWidth, parentHeight)
        let minParentSize = min(parentWidth, parentHeight)

        if maxParentSize / 2 > minParentSize {
            maxParentSize = (minParentSize * 2) - 2
        }

        let scanningZoneSize = maxParentSize / 2
        let overlayX = (parentWidth - scanningZoneSize) / 2
        let overlayY = (parentHeight - scanningZoneSize) / 2

        // Create the cutout rectangle
        let cutoutRect = CGRect(x: overlayX, y: overlayY, width: scanningZoneSize, height: scanningZoneSize)

        // Clear the cutout rectangle
        context.clear(cutoutRect)
    }
    
    func updateFrameAndRedraw(_ newFrame: CGRect) {
        frame = newFrame
        setNeedsDisplay()
    }
}
